/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.State;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.ConfigurationScreen;
import brentmaas.buildguide.common.screen.IScreenWrapper;
import brentmaas.buildguide.common.screen.ShapeScreen;
import brentmaas.buildguide.common.screen.ShapelistScreen;
import brentmaas.buildguide.common.screen.VisualisationScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import brentmaas.buildguide.common.screen.widget.ISlider;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.screen.widget.IWidget;
import brentmaas.buildguide.common.shape.ShapeSet;
import java.util.ArrayList;

public abstract class BaseScreen {
    protected String title = BuildGuide.screenHandler.translate("screen.buildguide.title");
    protected String titleNumberOfBlocksShape = BuildGuide.screenHandler.translate("screen.buildguide.numberofblocksshape");
    protected String titleNumberOfBlocksTotal = BuildGuide.screenHandler.translate("screen.buildguide.numberofblockstotal");
    protected String textEnabled = BuildGuide.screenHandler.translate("screen.buildguide.enable");
    protected IScreenWrapper wrapper;
    protected ArrayList<Property<?>> properties = new ArrayList();
    private IButton buttonClose;
    private ICheckboxRunnableButton buttonEnabled;
    private IButton buttonBuildGuide = BuildGuide.widgetHandler.createButton(5, 30, 120, 20, BuildGuide.screenHandler.translate("screen.buildguide.shape"), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.BuildGuide)), !(this instanceof ShapeScreen));
    private IButton buttonVisualisation = BuildGuide.widgetHandler.createButton(130, 30, 120, 20, BuildGuide.screenHandler.translate("screen.buildguide.visualisation"), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Visualisation)), !(this instanceof VisualisationScreen));
    private IButton buttonShapeList = BuildGuide.widgetHandler.createButton(255, 30, 120, 20, BuildGuide.screenHandler.translate("screen.buildguide.shapelist"), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Shapelist)), !(this instanceof ShapelistScreen));
    private IButton buttonConfiguration = BuildGuide.widgetHandler.createButton(380, 30, 120, 20, BuildGuide.screenHandler.translate("screen.buildguide.configuration"), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Settings)), !(this instanceof ConfigurationScreen));

    public void init() {
        this.buttonClose = BuildGuide.widgetHandler.createButton(this.wrapper.getWidth() - 25, 5, 20, 20, "X", () -> BuildGuide.screenHandler.showScreen(null));
        this.buttonEnabled = BuildGuide.widgetHandler.createCheckbox(5, 5, 20, 20, "", BuildGuide.stateManager.getState().enabled, false, () -> {
            BuildGuide.stateManager.getState().enabled = this.buttonEnabled.isCheckboxSelected();
        });
        this.addWidget(this.buttonEnabled);
        this.addWidget(this.buttonClose);
        this.addWidget(this.buttonBuildGuide);
        this.addWidget(this.buttonVisualisation);
        this.addWidget(this.buttonShapeList);
        this.addWidget(this.buttonConfiguration);
    }

    public void render() {
        this.drawShadowCentred(this.title, this.wrapper.getWidth() / 2, 10, 0xFFFFFF);
        this.drawShadowLeft(this.textEnabled, 30, 10, 0xFFFFFF);
        int titlesMax = Math.max(this.wrapper.getTextWidth(this.titleNumberOfBlocksShape), this.wrapper.getTextWidth(this.titleNumberOfBlocksTotal));
        this.drawShadowCentred(this.titleNumberOfBlocksShape, this.wrapper.getWidth() / 2 - this.wrapper.getTextWidth(this.title) / 2 - titlesMax / 2 - 20, 5, 0xFFFFFF);
        int n = BuildGuide.stateManager.getState().isShapeAvailable() ? BuildGuide.stateManager.getState().getCurrentShape().getNumberOfBlocks() : 0;
        this.drawShadowCentred(n + " (" + n / 64 + " x 64 + " + n % 64 + ")", this.wrapper.getWidth() / 2 - this.wrapper.getTextWidth(this.title) / 2 - titlesMax / 2 - 20, 20, 0xFFFFFF);
        this.drawShadowCentred(this.titleNumberOfBlocksTotal, this.wrapper.getWidth() / 2 + this.wrapper.getTextWidth(this.title) / 2 + titlesMax / 2 + 20, 5, 0xFFFFFF);
        int nTotal = 0;
        for (ShapeSet shapeSet : BuildGuide.stateManager.getState().shapeSets) {
            if (!shapeSet.visible) continue;
            nTotal += shapeSet.getShape().getNumberOfBlocks();
        }
        this.drawShadowCentred(nTotal + " (" + nTotal / 64 + " x 64 + " + nTotal % 64 + ")", this.wrapper.getWidth() / 2 + this.wrapper.getTextWidth(this.title) / 2 + titlesMax / 2 + 20, 20, 0xFFFFFF);
        for (Property property : this.properties) {
            property.render(this);
        }
    }

    public void setWrapper(IScreenWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void addWidget(IWidget widget) {
        if (this.wrapper != null) {
            if (widget instanceof IButton) {
                this.wrapper.addButton((IButton)widget);
            } else if (widget instanceof ITextField) {
                this.wrapper.addTextField((ITextField)widget);
            } else if (widget instanceof ICheckboxRunnableButton) {
                this.wrapper.addCheckbox((ICheckboxRunnableButton)widget);
            } else if (widget instanceof ISlider) {
                this.wrapper.addSlider((ISlider)widget);
            } else if (widget instanceof IShapeList) {
                this.wrapper.addShapeList((IShapeList)widget);
            }
        }
    }

    public void drawShadowLeft(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x, y, colour);
        }
    }

    public void drawShadowCentred(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x - this.wrapper.getTextWidth(text) / 2, y, colour);
        }
    }

    public void drawShadowRight(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x - this.wrapper.getTextWidth(text), y, colour);
        }
    }

    protected void addProperty(Property<?> p) {
        this.properties.add(p);
        p.addToScreen(this);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

