/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CloseableIterator;
import de.siegmar.fastcsv.reader.CommentStrategy;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import de.siegmar.fastcsv.reader.CsvRowSpliterator;
import de.siegmar.fastcsv.reader.NamedCsvRow;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.StringJoiner;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class NamedCsvReader
implements Iterable<NamedCsvRow>,
Closeable {
    private final CsvReader csvReader;
    private final CloseableIterator<CsvRow> csvIterator;
    private final CloseableIterator<NamedCsvRow> namedCsvIterator;
    private Set<String> header;
    private boolean isInitialized;

    private NamedCsvReader(CsvReader csvReader) {
        this.csvReader = csvReader;
        this.csvIterator = csvReader.iterator();
        this.namedCsvIterator = new NamedCsvRowIterator(this.csvIterator);
    }

    private void initialize() {
        if (!this.csvIterator.hasNext()) {
            this.header = Collections.emptySet();
        } else {
            CsvRow firstRow = (CsvRow)this.csvIterator.next();
            LinkedHashSet<String> headerSet = new LinkedHashSet<String>(firstRow.getFieldCount());
            for (String field : firstRow.getFields()) {
                if (headerSet.add(field)) continue;
                throw new IllegalStateException("Duplicate header field '" + field + "' found");
            }
            this.header = Collections.unmodifiableSet(headerSet);
        }
        this.isInitialized = true;
    }

    public static NamedCsvReaderBuilder builder() {
        return new NamedCsvReaderBuilder();
    }

    public Set<String> getHeader() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return this.header;
    }

    @Override
    public CloseableIterator<NamedCsvRow> iterator() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return this.namedCsvIterator;
    }

    @Override
    public Spliterator<NamedCsvRow> spliterator() {
        return new CsvRowSpliterator<NamedCsvRow>(this.iterator());
    }

    public Stream<NamedCsvRow> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }

    public String toString() {
        return new StringJoiner(", ", NamedCsvReader.class.getSimpleName() + "[", "]").add("header=" + this.header).add("csvReader=" + this.csvReader).toString();
    }

    public static final class NamedCsvReaderBuilder {
        private char fieldSeparator = (char)44;
        private char quoteCharacter = (char)34;
        private char commentCharacter = (char)35;
        private boolean skipComments;

        private NamedCsvReaderBuilder() {
        }

        public NamedCsvReaderBuilder fieldSeparator(char fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public NamedCsvReaderBuilder quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public NamedCsvReaderBuilder commentCharacter(char commentCharacter) {
            this.commentCharacter = commentCharacter;
            return this;
        }

        public NamedCsvReaderBuilder skipComments(boolean skipComments) {
            this.skipComments = skipComments;
            return this;
        }

        public NamedCsvReader build(Path path) throws IOException {
            return this.build(path, StandardCharsets.UTF_8);
        }

        public NamedCsvReader build(Path path, Charset charset) throws IOException {
            return new NamedCsvReader(this.csvReaderBuilder().build(path, charset));
        }

        public NamedCsvReader build(Reader reader) {
            return new NamedCsvReader(this.csvReaderBuilder().build(reader));
        }

        public NamedCsvReader build(String data) {
            return new NamedCsvReader(this.csvReaderBuilder().build(data));
        }

        private CsvReader.CsvReaderBuilder csvReaderBuilder() {
            return CsvReader.builder().fieldSeparator(this.fieldSeparator).quoteCharacter(this.quoteCharacter).commentCharacter(this.commentCharacter).commentStrategy(this.skipComments ? CommentStrategy.SKIP : CommentStrategy.NONE).errorOnDifferentFieldCount(true);
        }

        public String toString() {
            return new StringJoiner(", ", NamedCsvReaderBuilder.class.getSimpleName() + "[", "]").add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentCharacter=" + this.commentCharacter).add("skipComments=" + this.skipComments).toString();
        }
    }

    private class NamedCsvRowIterator
    implements CloseableIterator<NamedCsvRow> {
        private final CloseableIterator<CsvRow> csvIterator;

        NamedCsvRowIterator(CloseableIterator<CsvRow> csvIterator) {
            this.csvIterator = csvIterator;
        }

        @Override
        public boolean hasNext() {
            return this.csvIterator.hasNext();
        }

        @Override
        public NamedCsvRow next() {
            return new NamedCsvRow(NamedCsvReader.this.header, (CsvRow)this.csvIterator.next());
        }

        @Override
        public void close() throws IOException {
            this.csvIterator.close();
        }
    }
}

