/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.SwingUtil;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class PostProcessors {
    private final InstallV1 profile;
    private final boolean isClient;
    private final ProgressCallback monitor;
    private final boolean hasTasks;
    private final List<Install.Processor> processors;
    private static boolean clChecked = false;
    private static ClassLoader parentClassLoader = null;

    public PostProcessors(InstallV1 profile, boolean isClient, ProgressCallback monitor) {
        this.profile = profile;
        this.isClient = isClient;
        this.monitor = monitor;
        this.processors = profile.getProcessors(isClient ? "client" : "server");
        this.hasTasks = !this.processors.isEmpty();
    }

    public Version.Library[] getLibraries() {
        return this.hasTasks ? this.profile.getLibraries() : new Version.Library[]{};
    }

    public int getTaskCount() {
        return this.hasTasks ? 0 : this.profile.getLibraries().length + this.processors.size() + this.profile.getData(this.isClient).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Set<File> process(File librariesDir, File minecraft, File root, File installer) {
        try {
            Map<String, DataEntry> data = this.loadData(librariesDir);
            if (data == null) {
                return null;
            }
            data.put("SIDE", new DataEntry(this.isClient ? "client" : "server"));
            data.put("MINECRAFT_JAR", new FileEntry(minecraft));
            data.put("MINECRAFT_VERSION", new DataEntry(this.profile.getMinecraft()));
            data.put("ROOT", new FileEntry(root));
            data.put("INSTALLER", new FileEntry(installer));
            data.put("LIBRARY_DIR", new FileEntry(librariesDir));
            if (this.processors.size() == 1) {
                this.monitor.stage("Building Processor");
            } else {
                this.monitor.start("Building Processors");
            }
            List<List<Output>> allOutputs = this.buildOutputs(librariesDir, data, this.processors);
            if (allOutputs == null) {
                return null;
            }
            String libPrefix = librariesDir.getAbsolutePath().replace('\\', '/');
            if (!libPrefix.endsWith("/")) {
                libPrefix = libPrefix + '/';
            }
            HashSet<File> ret = new HashSet<File>();
            for (int x = 0; x < this.processors.size(); ++x) {
                File jar;
                this.monitor.progress((double)(x + 1) / (double)this.processors.size());
                this.log("===============================================================================");
                Install.Processor proc = this.processors.get(x);
                List<Output> outputs = allOutputs.get(x);
                if (!outputs.isEmpty()) {
                    boolean miss = false;
                    this.log("  Cache: ");
                    for (Output output : outputs) {
                        if (!output.file.exists()) {
                            this.log("    " + output.file + " Missing");
                            String path = output.file.getAbsolutePath().replace('\\', '/');
                            if (!path.startsWith(libPrefix)) {
                                miss = true;
                                continue;
                            }
                            String relative = "/cache/" + path.substring(libPrefix.length());
                            try {
                                InputStream input = DownloadUtils.class.getResourceAsStream(relative);
                                String[] stringArray = null;
                                try {
                                    if (input != null) {
                                        this.log("    Extracting output from " + relative);
                                        if (!output.file.getParentFile().exists()) {
                                            output.file.getParentFile().mkdirs();
                                        }
                                        Files.copy(input, output.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                        String sha1 = DownloadUtils.getSha1(output.file);
                                        if (output.sha1.equals(sha1)) {
                                            this.log("      Extraction completed: Checksum validated.");
                                            ret.add(output.file);
                                            continue;
                                        }
                                        this.log("    " + output.file);
                                        this.log("      Expected: " + output.sha1);
                                        this.log("      Actual:   " + sha1);
                                        miss = true;
                                        output.file.delete();
                                        continue;
                                    }
                                    miss = true;
                                    continue;
                                }
                                catch (Throwable sha1) {
                                    stringArray = sha1;
                                    throw sha1;
                                }
                                finally {
                                    if (input == null) continue;
                                    if (stringArray != null) {
                                        try {
                                            input.close();
                                        }
                                        catch (Throwable sha1) {
                                            stringArray.addSuppressed(sha1);
                                        }
                                        continue;
                                    }
                                    input.close();
                                    continue;
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return null;
                            }
                        }
                        String sha = DownloadUtils.getSha1(output.file);
                        if (sha.equals(output.sha1)) {
                            this.log("    " + output.file + " Validated: " + output.sha1);
                            ret.add(output.file);
                            continue;
                        }
                        this.log("    " + output.file);
                        this.log("      Expected: " + output.sha1);
                        this.log("      Actual:   " + sha);
                        miss = true;
                        output.file.delete();
                    }
                    if (!miss) {
                        this.log("  Cache Hit!");
                        continue;
                    }
                }
                if (!(jar = proc.getJar().getLocalPath(librariesDir)).exists() || !jar.isFile()) {
                    this.error("  Missing Jar for processor: " + jar.getAbsolutePath());
                    return null;
                }
                JarFile jarFile = new JarFile(jar);
                String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                jarFile.close();
                if (mainClass == null || mainClass.isEmpty()) {
                    this.error("  Jar does not have main class: " + jar.getAbsolutePath());
                    return null;
                }
                this.monitor.message("  MainClass: " + mainClass, ProgressCallback.MessagePriority.LOW);
                ArrayList<URL> classpath = new ArrayList<URL>();
                StringBuilder err = new StringBuilder();
                this.monitor.message("  Classpath:", ProgressCallback.MessagePriority.LOW);
                this.monitor.message("    " + jar.getAbsolutePath(), ProgressCallback.MessagePriority.LOW);
                classpath.add(jar.toURI().toURL());
                for (Artifact dep : proc.getClasspath()) {
                    File lib = dep.getLocalPath(librariesDir);
                    if (!lib.exists() || !lib.isFile()) {
                        err.append("\n  ").append(dep.getDescriptor());
                    }
                    classpath.add(lib.toURI().toURL());
                    this.monitor.message("    " + lib.getAbsolutePath(), ProgressCallback.MessagePriority.LOW);
                }
                if (err.length() > 0) {
                    this.error("  Missing Processor Dependencies: " + err.toString());
                    return null;
                }
                ArrayList<String> args = new ArrayList<String>();
                for (String arg : proc.getArgs()) {
                    char start = arg.charAt(0);
                    char end = arg.charAt(arg.length() - 1);
                    if (start == '[' && end == ']') {
                        args.add(Artifact.from(arg.substring(1, arg.length() - 1)).getLocalPath(librariesDir).getAbsolutePath());
                        continue;
                    }
                    args.add(Util.replaceTokens(data, arg));
                }
                if (err.length() > 0) {
                    this.error("  Missing Processor data values: " + err.toString());
                    return null;
                }
                this.monitor.message("  Args: " + args.stream().map(a -> a.indexOf(32) != -1 || a.indexOf(44) != -1 ? '\"' + a + '\"' : a).collect(Collectors.joining(", ")), ProgressCallback.MessagePriority.LOW);
                URLClassLoader cl = new URLClassLoader(classpath.toArray(new URL[classpath.size()]), this.getParentClassloader());
                Thread currentThread = Thread.currentThread();
                ClassLoader threadClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(cl);
                try {
                    Class<?> cls = Class.forName(mainClass, true, cl);
                    Method main = cls.getDeclaredMethod("main", String[].class);
                    main.invoke(null, new Object[]{args.toArray(new String[args.size()])});
                }
                catch (InvocationTargetException ite) {
                    Throwable e2 = ite.getCause();
                    this.handleError(e2);
                    Set<File> end = null;
                    return end;
                }
                catch (Throwable e) {
                    this.handleError(e);
                    Set<File> e2 = null;
                    return e2;
                }
                finally {
                    currentThread.setContextClassLoader(threadClassloader);
                }
                if (outputs.isEmpty()) continue;
                for (Output output : outputs) {
                    ret.add(output.file);
                    if (!output.file.exists()) {
                        err.append("\n    ").append(output.file).append(" missing");
                        continue;
                    }
                    String sha = DownloadUtils.getSha1(output.file);
                    if (sha.equals(output.sha1)) {
                        this.log("  Output: " + output.file + " Checksum Validated: " + sha);
                        continue;
                    }
                    err.append("\n    ").append(output.file).append("\n      Expected: ").append(output.sha1).append("\n      Actual:   ").append(sha);
                    if (SimpleInstaller.debug || output.file.delete()) continue;
                    err.append("\n      Could not delete file");
                }
                if (err.length() <= 0) continue;
                this.error("  Processor failed, invalid outputs:" + err.toString());
                return null;
            }
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void handleError(Throwable e) {
        e.printStackTrace();
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to run processor: ").append(e.getClass().getName());
        if (e.getMessage() != null) {
            buf.append(':').append(e.getMessage());
        }
        if (e instanceof SSLException) {
            buf.append("\nThis is a SSL Exception, this might be caused by you having an outdated java install.").append("\nTry updating your java before trying again.");
        }
        buf.append("\nSee log for more details");
        this.error(buf.toString());
        if (e.getMessage() == null) {
            this.error("Failed to run processor: " + e.getClass().getName() + "\nSee log for more details.");
        } else {
            this.error("Failed to run processor: " + e.getClass().getName() + ":" + e.getMessage() + "\nSee log for more details.");
        }
    }

    private void error(String message) {
        if (!SimpleInstaller.headless) {
            JOptionPane.showOptionDialog(null, message, "Error", -1, 0, null, new Object[]{"Ok", SwingUtil.createLogButton()}, "");
        }
        for (String line : message.split("\n")) {
            this.monitor.message(line);
        }
    }

    private void log(String message) {
        for (String line : message.split("\n")) {
            this.monitor.message(line);
        }
    }

    private synchronized ClassLoader getParentClassloader() {
        if (!clChecked) {
            clChecked = true;
            if (!System.getProperty("java.version").startsWith("1.")) {
                try {
                    Method getPlatform = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
                    parentClassLoader = (ClassLoader)getPlatform.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    this.log("No platform classloader: " + System.getProperty("java.version"));
                }
            }
        }
        return parentClassLoader;
    }

    private Map<String, DataEntry> loadData(File librariesDir) throws IOException {
        Map<String, String> cfg = this.profile.getData(this.isClient);
        if (cfg.isEmpty()) {
            return new HashMap<String, DataEntry>();
        }
        HashMap<String, DataEntry> ret = new HashMap<String, DataEntry>();
        StringBuilder err = new StringBuilder();
        Path temp = Files.createTempDirectory("forge_installer", new FileAttribute[0]);
        this.monitor.start("Created Temporary Directory: " + temp);
        double steps = cfg.size();
        int progress = 1;
        for (String key : cfg.keySet()) {
            this.monitor.progress((double)progress++ / steps);
            String value = cfg.get(key);
            DataEntry entry = null;
            if (value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
                Artifact artifact = Artifact.from(value.substring(1, value.length() - 1));
                entry = new ArtifactEntry(artifact, librariesDir);
            } else if (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                entry = new DataEntry(value.substring(1, value.length() - 1));
            } else {
                File target = Paths.get(temp.toString(), value).toFile();
                this.monitor.message("  Extracting: " + value);
                if (!DownloadUtils.extractFile(value, target)) {
                    err.append("\n  ").append(value);
                }
                entry = new FileEntry(target);
            }
            ret.put(key, entry);
        }
        if (err.length() > 0) {
            this.error("Failed to extract files from archive: " + err.toString());
            return null;
        }
        return ret;
    }

    private List<List<Output>> buildOutputs(File librariesDir, Map<String, DataEntry> data, List<Install.Processor> processors) {
        ArrayList<List<Output>> ret = new ArrayList<List<Output>>();
        for (Install.Processor proc : processors) {
            Map<String, String> outputs = proc.getOutputs();
            if (outputs.isEmpty()) {
                ret.add(Collections.emptyList());
                continue;
            }
            ArrayList<Output> pout = new ArrayList<Output>();
            for (String key : outputs.keySet()) {
                char start = key.charAt(0);
                char end = key.charAt(key.length() - 1);
                String file = null;
                file = start == '[' && end == ']' ? Artifact.from(key.substring(1, key.length() - 1)).getLocalPath(librariesDir).getAbsolutePath() : Util.replaceTokens(data, key);
                String value = outputs.get(key);
                if (value != null) {
                    value = Util.replaceTokens(data, value);
                }
                if (key == null || value == null) {
                    this.error("  Invalid configuration, bad output config: [" + key + ": " + value + "]");
                    return null;
                }
                pout.add(new Output(new File(file), value));
            }
            ret.add(pout);
        }
        return ret;
    }

    private static class Output {
        private final File file;
        private final String sha1;

        private Output(File file, String sha1) {
            this.file = file;
            this.sha1 = sha1;
        }
    }

    private static class ArtifactEntry
    extends DataEntry {
        private final Artifact artifact;

        protected ArtifactEntry(Artifact artifact, File root) {
            super(artifact.getLocalPath(root).getAbsolutePath());
            this.artifact = artifact;
        }
    }

    private static class FileEntry
    extends DataEntry {
        private final File file;

        protected FileEntry(File file) {
            super(file.getAbsolutePath());
            this.file = file;
        }
    }

    private static class DataEntry
    implements Supplier<String> {
        protected final String value;

        protected DataEntry(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public String get() {
            return this.toString();
        }
    }
}

